require( "quest/m1_dress_instructions/convout.lua" );
combine_speech_tables();

flo_spec =
{
	name = "FLO";

	command = function(actor)
		prepare_actor_text(actor, flo_text_spec)
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

instructions_title_spec = 
{
	name = "INSTRUCTIONS_TITLE";
	
	command = function(actor)
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 210,
			x = 400-175,
			w = 350,
			h = 60,
			bubble = false,
			lineheight = 50,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:Say("bead_machine_instructions_title");
	end;
};

instructions_body_spec = 
{
	name = "INSTRUCTIONS_BODY";
	
	command = function(actor)
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 300,
			x = 400-225,
			w = 450,
			h = 150,
			bubble = false,
			lineheight = 35,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:Say("bead_machine_instructions_body");
	end;
};

instructions_background_spec = 
{
	name = "INSTRUCTIONS_BACKGROUND";
	halo = "background";
	
	command = function(actor)
		actor:SetPointAtCursor("cursor");
	end;
	
	on_click = function(flo, actor)
		local item = game:GetInvUsage();
		
		if item == "" then
			sfx:PlaySFX("audio/sfx/checklist_zoom2.ogg");
			scene:ReturnFromScene();
		end;
	end;
	
	on_use_inv = function(item, flo, background)
		return RESPONSE.INV_HANDLED;
	end;
};

instructions_header_spec = 
{
	name = "INSTRUCTIONS_HEADER";
	
	command = function(actor)
		actor:ModifySaySpec
		{
			color = { a = 1, r = 1, g = 1, b = 1 },
			y = 130,
			x = 400-225,
			w = 450,
			h = 150,
			bubble = false,
			lineheight = 60,
			outline_size = 0,
			font = "fonts/itc_eras_std_bold.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:Say("bead_machine_instructions_header");
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			--testing
		end
		
		scene:SetCameraFollowActor(nil);
		scene:SetTextBoundsXY(20, 20);
		
		game:Set("seen_dress_shop_instructions", 1);
		
		scene:SetFadeColor { a = 1, r = 0, g = 0, b = 0 };
		scene:SetFadeSpeed(1)
		scene:SetFadeTarget { a = 0, r = 0, g = 0, b = 0 };
		
		sfx:PlaySFX("audio/sfx/checklist_zoom1.ogg");
	end;
};

scene_spec =
{
	--atlas = 
	--{
	--	"pieces" -- load pieces
	--};
	
	bg_image = 
	{
		{ "background", 1 },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec,
		instructions_background_spec,
		instructions_title_spec,
		instructions_body_spec,
		instructions_header_spec,
		scene_setup,
	};
};
